#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_OrderReport : BaseTest 
	{
		private DataTable _dtOrderedTest;
		private DataTable _dtOrderedComponent;

		private System.DateTime _startDate = System.DateTime.Now.AddMonths(-6);
		private System.DateTime _endDate = System.DateTime.Now;
		private System.DateTime _invalidStart = System.DateTime.Now.AddMonths(6);
		private System.DateTime _invalidEnd = System.DateTime.Now;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtOrderedTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedTest WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				//**Get OrderedComponent
				this._dtOrderedComponent = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedComponent WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);


				this.RefreshData = false;
			}
		}

		[Test]
		public void GetMultiOrderReportCount_Pass()
		{
			int count = DAL.OrderReport.GetMultiOrderReportCount(this._startDate, this._endDate, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(count > 0);
		}

		[Test]
		public void GetMultiOrderReportCount_Fail()
		{
			try
			{
				DAL.OrderReport.GetMultiOrderReportCount(this._startDate, DateTime.MinValue, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				DAL.OrderReport.GetMultiOrderReportCount(DateTime.MinValue, this._endDate, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}

		[Test]
		public void GetReportSingleOrderComponentHistory_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedComponent.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];

			DataTable dtTest = DAL.OrderReport.GetReportSingleOrderComponentHistory(unitGuid);
			
			Assert.AreEqual(32, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetReportSingleOrderComponentHistory_Fail()
		{
			DataTable dtTest = DAL.OrderReport.GetReportSingleOrderComponentHistory(Guid.Empty);
		}

		[Test]
		public void GetReportSingleOrderTestHistory_Pass()
		{
			System.Guid testGuid = (System.Guid)this._dtOrderedTest.Rows[0][TABLES.OrderedTest.OrderedTestGuid];

			DataTable dtTest = DAL.OrderReport.GetReportSingleOrderTestHistory(testGuid);

			Assert.AreEqual(31, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetReportSingleOrderTestHistory_Fail()
		{
			DataTable dtTest = DAL.OrderReport.GetReportSingleOrderTestHistory(Guid.Empty);
		}

		[Test]
		public void GetReportMultiOrderHistory_Pass()
		{
			DataTable dtTest = DAL.OrderReport.GetReportMultiOrderHistory(this._startDate, this._endDate, UnitTestConfig.TestDivisionCode);

			Assert.AreEqual(18, dtTest.Columns.Count, "Columns.Count");     //CR3319
		}

		[Test]
		public void GetReportMultiOrderHistory_Fail()
		{
			try
			{
				DAL.OrderReport.GetReportMultiOrderHistory(this._startDate, DateTime.MinValue, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}

			try
			{
				DAL.OrderReport.GetReportMultiOrderHistory(DateTime.MinValue, this._endDate, UnitTestConfig.TestDivisionCode);
				Assert.IsTrue(false, AssertionFailReasons.ArgumentExceptionExpected);
			}
			catch(ArgumentException)
			{
				Assert.IsTrue(true);
			}
		}
	}
}

#endif
